
*****************************************************
*           REGRESSIONSANALYSE                      *
*              Josef Brüderl                        *
*              November 2018                        *
*****************************************************

*****************************************************
* Das multiple Regressionsmodell
*****************************************************

clear 
set more off
version 15

* Daten: ALLBUS 2002
cd   "C:\Users\Brüderl\LRZ Sync+Share\Vorlesung Querschnittsdatenanalyse\Do Files"        //Arbeitsverzeichnis
use  AllbReg, clear


* -----------------------------------
* Datenaufbereitung
* -----------------------------------
* Hauptberuflich ganztags, bis Alter 65
keep if  hauptber == 1
keep if  alter <  66

* Magnitudeprestige Vater (/100)
replace  prestv = prestv / 100


* ---------------------------------------------
* Präsentation der Regressionskoeffizienten
* ---------------------------------------------

* Einkommensregression
regress    eink bild prestv ost frau i.beruf

* Ausgabe in einer schönen Tabelle
* Ben Jann's ESTOUT-Paket wird hier verwendet, um eine schöne RTF-Tabelle
* zu erzeugen. Installieren mit folgendem Befehl:
*    net install st0085_1.pkg
esttab using "RegTabelle.rtf", r2 b(%6.1f) replace


* Koeffizientenplot (Ado von Ben Jann, 2014)
* net install gr0059_1.pkg
coefplot, drop(_cons) xline(0)  base                                        ///
    title("Regressionskoeffizienten und 95%-KI", margin(medium))            ///
    xtitle("Effekt auf monatliches Nettoeinkommen in Euro",                 ///
	       size(medium) margin(0 0 0 2))                                    ///
    xlabel(-800(100)1200, grid alternate labsize(small))                    ///             
    ylabel(1 "Bildungsjahre" 2 "Prestige Vater / 100" 3 "Ostdeutscher"      ///
	       4 "Frau"  5 "Beruf: Arbeiter (Referenz)" 6 "Beruf: Angestellter" ///
		   7 "Beruf: Beamter" 8 "Beruf: Selbständiger", labsize(small))             


* -----------------------------------
* Profile-Plot (PP)
* -----------------------------------

* Einkommensregression
regress  eink bild prestv ost i.frau i.beruf

* Profile-Plot: Bildungseffekt und Geschlechtseffekt
margins frau, at(bild=(8 18)) noatlegend    //mit "(mean)_all" kommt das Gleiche raus
marginsplot,   noci    title("")                                  ///
   plot1opts(lwidth(thick) lcolor(red)  msymbol(i))               ///
   plot2opts(lwidth(thick) lcolor(blue) msymbol(i))               ///
   ytitle(Einkommen, size(large))                                 ///  
   ylabel(0(500)3000, labsize(medlarge) angle(horizontal) grid)   ///
   xtitle(Bildungsjahre, size(large) margin(medsmall))            ///  
   xlabel(8(1)18, labsize(medlarge))                              ///
   legend(pos(11) ring(0) row(2) order(1 2) lab(1 "Mann")         ///
		     lab(2 "Frau") size(medlarge))                        ///
   ysize(5)


*----------------------------------------------
* Interpretation einer Polynomregression
*----------------------------------------------   

regress    eink bild ost frau c.exp c.exp#c.exp
* regress    eink bild ost frau c.exp##c.exp      // äquivalent

test  exp exp##exp   //ist exp insgesamt signifikant?

margins, dydx(exp)                                        //AME
margins, dydx(exp) over(frau)                             //AME für Männer und Frauen
margins, dydx(exp) at(exp=(0 10 20 30 40 50)) noatlegend  //MEs

* PP mit "margins" + Konfidenzintervall
margins, at(exp=(0(2)50)) noatlegend
marginsplot,  recast(line) recastci(rarea) title("")            ///
   plotopts(lwidth(thick) lcolor(blue))                         ///
   ciopts(lcolor(blue) fcolor(blue*.3))                         ///
   ytitle(Einkommen, size(large))                               ///  
   ylabel(0(500)3000, labsize(medlarge) angle(horizontal) grid) ///
   xtitle(Berufserfahrung, size(large) margin(medsmall))        ///  
   xlabel(0(10)50, labsize(medlarge)) 


*------------------------------------------------------
* Interpretation einer semi-logarithmischen Regression
*------------------------------------------------------

generate lneink = ln(eink)
set cformat %9.4f              //hier braucht man 4 Nachkommastellen
regress  lneink bild ost frau c.exp c.exp#c.exp

